/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.MarkerParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.Language;

public class MarkerBlock
extends OutputBlock {
    static final long serialVersionUID = 1L;
    private int markerBlockSerializedDataVersion = 1;
    public static final int FIRST_OPCODE = 224;
    public static final int LAST_OPCODE = 231;

    public MarkerBlock() {
    }

    public MarkerBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected int getDefaultOrder() {
        return 10500;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = new int[HardwareFactory.getInstance().getResourceNames().length];
        result[this.getNumberType()] = 1;
        return result;
    }

    public String getNumberPrefix() {
        return "M";
    }

    public int getNumberType() {
        return 10;
    }

    public BlockParameter getParameter() {
        if (this.fOutputParameter == null) {
            this.fOutputParameter = new MarkerParameter(this);
        }
        return this.fOutputParameter;
    }

    public int getResourceIndex() {
        return 10;
    }

    public String getToolTipText() {
        String name = this.getLanguageKey();
        this.fToolTipText = Language.getString(name, name);
        return this.fToolTipText;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.getParameter().init(interpreter, forceReset);
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[1];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "1");
    }

    public void setBinaryValue(boolean newValue) {
        this.fValue = newValue;
        this.fProcessImageValue = newValue;
    }

    public String getLanguageKey() {
        if (this.getClass() == MarkerBlock.class) {
            switch (this.getNumber()) {
                case 8: {
                    return "block.Marker.startupFlag";
                }
                case 25: {
                    return "block.Marker.OnBoardLCD";
                }
                case 26: {
                    return "block.Marker.TDLCD";
                }
                case 27: {
                    return "block.Marker.MsgLanguage";
                }
            }
            return super.getLanguageKey();
        }
        return super.getLanguageKey();
    }
}

